package simpleTypes

object SumExample {
  // a sum type
  sealed trait Int_String_Sum
  case class In_Int(val i: Int) extends Int_String_Sum
  case class In_String(val s: String) extends Int_String_Sum
  
  // The keyword "sealed" above states that we want to close this type: the
  // compiler will refuse to add another case to the sum later on.
  
  def main(args: Array[String]) = {
    // introduction
		val x1: Int_String_Sum = In_Int(5);
		val x2: Int_String_Sum = In_String("shrdlu");
		
		// elimination
		// We can use pattern matching here
		x1 match {
		  case In_Int(i)    => println("In_Int: " + i)
		  case In_String(s) => println("In_String: " + s)
		}
		x2 match {
		  case In_Int(i)    => println("In_Int: " + i)
		  case In_String(s) => println("In_String: " + s)
		}
		
		// Compared to Java:
		// - No more unsafe type casts or instanceof checks.
		// - The compiler will prevent to add more cases to the sum. 
	  // - The compiler can warn the programmer if some case is forgotten
		// (This should arguably be an error)
		x2 match {
		  case In_Int(i)    => println("In_Int: " + i)
		  // warning: match may not be exhaustive. In would fail on In_String(_)
		}
		
  }
}
